/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于环境页面
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.9.18
 *      内容 : 所有代码
 *************************************************************************************************/

/* exported mc_environment_get_data */


/* global $ */
/* global mc_sdk_param */

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取环境界面数据
 * 参数:
 *     @param { Promise<String> } Str_order 指令命令
 * 返回：
 *    @return { Promise<Array> }
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.9.18
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_environment_get_data(Str_order, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }

    var obj_req = new mc_sdk_param();

    obj_req.set_param_clear();
    obj_req.set_cmd("GET_PARAM");
    obj_req.set_func("HW_FUNCCARD_STATUS");
    obj_req.set_param_value("CARD", Str_order);
    $.post("/access_shell", obj_req.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        var arr_val = [];
        var arr_each = [];
        var obj_res = new mc_sdk_param();

        obj_res.set_json(result);
        var str_error_date = obj_res.get_param_value("ERROR_CODE");
        var attr_cnt = obj_res.get_attr_cnt("CARD");

        for (var idx_attr = 0; idx_attr < attr_cnt; idx_attr++) {
            //获取属性名
            var attr_name = obj_res.get_attr_name("CARD", idx_attr);
            var attr_val = obj_res.get_attr_val("CARD", attr_name);

            arr_each = [attr_name, attr_val];
            arr_val.push(arr_each);
            arr_each = [];
        }


        fun_callback(arr_val, str_error_date);
    });
}
